// Copyright 2006 Adobe Macromedia, Inc. All rights reserved.

var Spry;
if (!Spry) Spry = {};
if (!Spry.DesignTime) Spry.DesignTime = {};
if (!Spry.DesignTime.Widget) Spry.DesignTime.Widget = {};

Spry.DesignTime.Widget.Base = function(dom, objName, element)
{
    this.dom = dom;
    this.objName = objName;
    this.element = this.getElement(element);
    this.element_id = (typeof element == "string" || !element) ? element : element.id;
};

Spry.DesignTime.Widget.Base.addClassName = function(ele, className)
{
	if (!ele || !className)
		return;

	var tclass = ele.getTranslatedAttribute("class");
 	if (!tclass || (tclass.search(new RegExp("\\b" + className + "\\b")) != -1))
		return;

	ele.setTranslatedAttribute("class", tclass + (tclass ? " " : "") + className);
};

Spry.DesignTime.Widget.Base.removeClassName = function(ele, className)
{
	if (!ele || !className)
		return;

	var tclass = ele.getTranslatedAttribute("class");
	if (!tclass || (tclass.search(new RegExp("\\b" + className + "\\b")) == -1))
		return;

	ele.setTranslatedAttribute("class", tclass.replace(new RegExp("\\s*\\b" + className + "\\b", "g"), ""));
};

Spry.DesignTime.Widget.Base.hasClassName = function(ele, className)
{
	if (!ele || !className)
		return false;
	var tclass = ele.getTranslatedAttribute("class");
	return (tclass && tclass.search(new RegExp("\\b" + className + "\\b")) != -1);
};

Spry.DesignTime.Widget.Base.getElementChildrenRaw = function(element)
{
	var children = [];
	
	if( element )
	{
  	var child = element.firstChild;
  	while (child)
  	{
  		if (child.nodeType == 1 /* Node.ELEMENT_NODE */)
  			children.push(child);
  		child = child.nextSibling;
  	}
  }
  
	return children;
};

Spry.DesignTime.Widget.Base.getElementChildren = function(element)
{	
	//see if there is some none HTML tags between the container and the panels
	var elementToUse = element;
	if( elementToUse && 
	   	elementToUse.hasChildNodes() && 
		elementToUse.childNodes.length == 1 &&
		(elementToUse.firstChild.nodeType != Node.ELEMENT_NODE || !elementToUse.firstChild.isHtmlTag()) )
	{
		var foundNode = dwscripts.getFirstHtmlTag(elementToUse.firstChild);
		if( foundNode ) {
			elementToUse = foundNode.parentNode;
		}
	}
	
	//get all the children
	var rawChildren = Spry.DesignTime.Widget.Base.getElementChildrenRaw(elementToUse);
	
	//go through and filter out any non HTML tags in the arrray
	var filteredChildren = new Array();
	for( var i = 0 ; i < rawChildren.length ; i++ )
	{		
		goodChild = rawChildren[i];
		if(!goodChild.isHtmlTag() ) 
		{
			//wasn't a good child, look down this child node for a better one
			goodChild = dwscripts.getFirstHtmlTag(goodChild.firstChild);
		}
		
		if( goodChild ) {
			filteredChildren.push(goodChild);
		}
	}
	
	return filteredChildren;
};

Spry.DesignTime.Widget.Base.addEventListener = function(element, eventType, handler, capture)
{
	try
	{
		if (element.addEventListener)
			element.addEventListener(eventType, handler, capture);
		else if (element.attachEvent)
			element.attachEvent("on" + eventType, handler);
	}
	catch (e) {}
};

Spry.DesignTime.Widget.Base.setOptions = function(obj, optionsObj, ignoreUndefinedProps)
{
	if (!optionsObj)
		return;
	for (var optionName in optionsObj)
	{
		if (ignoreUndefinedProps && optionsObj[optionName] == undefined)
			continue;
		obj[optionName] = optionsObj[optionName];
	}
};

Spry.DesignTime.Widget.Base.getHidePanelIcon = function()
{
	return dw.getConfigurationPath() + "/Shared/MM/Images/disclosure_close.png";
};

Spry.DesignTime.Widget.Base.getShowPanelIcon = function()
{
	return dw.getConfigurationPath() + "/Shared/MM/Images/disclosure_open.png";
};

Spry.DesignTime.Widget.Base.addShowPanelContextButton = function(buttonContainer)
{
	if( !buttonContainer || !buttonContainer.setTranslatedAttribute )
	{
		if( dw.isDebugBuild() ) alert("DEBUG ALERT: bad buttonContainer passed into 'Spry.DesignTime.Widget.Base.addShowPanelContextButton'");
		return;
	}
	buttonContainer.setTranslatedAttribute("dwedit:hascontextbutton", "hascontextbutton");
	buttonContainer.setTranslatedAttribute("dwedit:contextbuttonurl", Spry.DesignTime.Widget.Base.getShowPanelIcon());
	buttonContainer.setTranslatedAttribute("dwedit:contextbuttontooltip", dw.loadString("spry/widget/tooltip/show panel"));
};

Spry.DesignTime.Widget.Base.addHidePanelContextButton = function(buttonContainer)
{
	if( !buttonContainer || !buttonContainer.setTranslatedAttribute )
	{
		if( dw.isDebugBuild() ) alert("DEBUG ALERT: bad buttonContainer passed into 'Spry.DesignTime.Widget.Base.addHidePanelContextButton'");
		return;
	}
	buttonContainer.setTranslatedAttribute("dwedit:hascontextbutton", "hascontextbutton");
	buttonContainer.setTranslatedAttribute("dwedit:contextbuttonurl", Spry.DesignTime.Widget.Base.getHidePanelIcon());
	buttonContainer.setTranslatedAttribute("dwedit:contextbuttontooltip", dw.loadString("spry/widget/tooltip/hide panel"));
};

Spry.DesignTime.Widget.Base.removeContextButton = function(buttonContainer)
{
	if( !buttonContainer || !buttonContainer.removeTranslatedAttribute )
	{
		if( dw.isDebugBuild() ) alert("DEBUG ALERT: bad buttonContainer passed into 'Spry.DesignTime.Widget.Base.removeContextButton'");
		return;
	}
	buttonContainer.removeTranslatedAttribute("dwedit:hascontextbutton");
	buttonContainer.removeTranslatedAttribute("dwedit:contextbuttonurl");
	buttonContainer.removeTranslatedAttribute("dwedit:contextbuttontooltip");
};



// For convenience, we'll add these static methods as members of the widget class itself.
Spry.DesignTime.Widget.Base.prototype.addClassName = Spry.DesignTime.Widget.Base.addClassName;
Spry.DesignTime.Widget.Base.prototype.removeClassName = Spry.DesignTime.Widget.Base.removeClassName;
Spry.DesignTime.Widget.Base.prototype.hasClassName = Spry.DesignTime.Widget.Base.hasClassName;
Spry.DesignTime.Widget.Base.prototype.getElementChildren = Spry.DesignTime.Widget.Base.getElementChildren;
Spry.DesignTime.Widget.Base.prototype.addEventListener = Spry.DesignTime.Widget.Base.addEventListener;
Spry.DesignTime.Widget.Base.prototype.setOptions = Spry.DesignTime.Widget.Base.setOptions;
Spry.DesignTime.Widget.Base.prototype.getHidePanelIcon = Spry.DesignTime.Widget.Base.getHidePanelIcon;
Spry.DesignTime.Widget.Base.prototype.getShowPanelIcon = Spry.DesignTime.Widget.Base.getShowPanelIcon;
Spry.DesignTime.Widget.Base.prototype.addShowPanelContextButton = Spry.DesignTime.Widget.Base.addShowPanelContextButton;
Spry.DesignTime.Widget.Base.prototype.addHidePanelContextButton = Spry.DesignTime.Widget.Base.addHidePanelContextButton;
Spry.DesignTime.Widget.Base.prototype.removeContextButton = Spry.DesignTime.Widget.Base.removeContextButton;



Spry.DesignTime.Widget.Base.prototype.getObjectName = function()
{
	return this.objName;
};

Spry.DesignTime.Widget.Base.prototype.getElement = function(ele)
{
	if (ele && typeof ele == "string")
		return this.dom.getElementById(ele);
	return ele;
}

Spry.DesignTime.Widget.Base.prototype.ensureValidElements = function()
{
	if( this.element && 
	   this.element.ownerDocument && 
	   this.element.id == this.element_id )
	return; //node is still good
	
	//refind our element in the document
	this.element = this.getElement(this.element_id);
};

Spry.DesignTime.Widget.Base.prototype.updateConstructorOptions = function(className, numReqCArgs, opts)
{
	var consRegExp = new RegExp(className.replace(/\./g, "\\.") + "\\s*?\\(\\s*?[\"']" + this.element_id + "[\"']");
	var scriptTags = this.dom.getElementsByTagName("script");
	for( var i = 0; i < scriptTags.length; i++ )
	{
		var sTag = scriptTags[i];
		var src = sTag.innerHTML;
		if(!src)
			continue;
		var cOffset = src.search(consRegExp);
		if (cOffset != -1)
		{
			var args = Spry.DesignTime.Editing.Utils.getParamsAsStrings(src, cOffset, '(', ')');
			var cleanOpts = {};
			this.setOptions(cleanOpts, opts, true);
			var optStr = cleanOpts.toSource().replace(/^\(|\)$/g, "");
			optStr = (optStr == "{}") ? "" : optStr;
			var optStart;
			if (args.length > numReqCArgs)
			{
				// The constructor has an options object.
				optStart = args._offsets[numReqCArgs];
				optEnd = optStart + args[numReqCArgs].length;

				if (optStr)
					optStr = " " + optStr;
				else
				{
					// We'll be removing the existing options object
					// from the constructor call, so include the ','
					// character.
					--optStart;
				}
			}
			else
			{
				// The constructor has no options object.
				optStart = args._offsets[numReqCArgs - 1] + args[numReqCArgs - 1].length;
				optEnd = optStart;

				if (optStr)
				{
					// We're adding an options object to constructor call
					// that did not already have one. Add a ',' character
					// in front of the optStr we are adding.
					optStr = ", " + optStr;
				}
			}

			sTag.innerHTML = src.substr(0, optStart) + optStr + src.substr(optEnd);
		}
	}
};

Spry.DesignTime.Widget.Base.prototype.getConstructorArgs = function(className)
{
	var consRegExp = new RegExp(className.replace(/\./g, "\\.") + "\\s*?\\(\\s*?[\"']" + this.element_id + "[\"']");
	var scriptTags = this.dom.getElementsByTagName("script");
	for( var i = 0; i < scriptTags.length; i++ )
	{
		var sTag = scriptTags[i];
		var src = sTag.innerHTML;
		if(!src)
			continue;
		var cOffset = src.search(consRegExp);
		if (cOffset != -1)
		{
			var args = Spry.DesignTime.Editing.Utils.getParamsAsStrings(src, cOffset, '(', ')');
			return args;
		}
	}
	return null;
};

